
/* Yaesu FH-2 Remote Control Emulator
  By Glen Popiel - KW5GP
  KW5GP@ARRL.NET

  Emulates the Yaesu FH-2 Remote Control
*/

#define debug false

#include <Keypad.h> // Include the Keypad library

#include <SPI.h>  // Include the SPI library

// Define the Keypad layout
const byte ROWS = 4; //four rows
const byte COLS = 4; //three columns

// Assign a character to each key
char keys[ROWS][COLS] =
{
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};

byte rowPins[ROWS] = {5, 4, 3, 2}; //connect to the row pinouts of the keypad
byte colPins[COLS] = {9, 8, 7, 6}; //connect to the column pinouts of the keypad

Keypad keypad = Keypad( makeKeymap(keys), rowPins, colPins, ROWS, COLS ); // Instantiate the keypad object

const int Chip_A  = 10; // Set the Chip Select for digital pot A
const int Chip_B = 14;  // Set the Chip Select for digital pot B
const int Shutdown_Pin = 15;// Set the Shutdown I/O pin for the digital pots

int Row = 0;  // Variable for the Row of Pot Arrays Values to use

// Define the Pot Array Values
int Value[13][4] =
{
  248, 254, 254, 254, // Key 1
  236, 254, 254, 254, // Key 2
  224, 254, 254, 254, // Key 3
  207, 254, 254, 254, // Key 4
  187, 254, 254, 254, // Key 5
  165, 254, 254, 254, // Key 6
  133, 254, 254, 254, // Key 7
  95, 254, 254, 254, // Key 18
  43, 254, 254, 254, // Key 9
  0, 90, 254, 254, // Key 10
  0, 216, 254, 254, // Key 11
  0, 0, 127, 254, // Key 12
  254, 254, 254, 254 // Maximum resistance value
};

void setup()
{
  // Setup digital pot I/O pins
  pinMode (Chip_A, OUTPUT);
  pinMode (Chip_B, OUTPUT);
  pinMode (Shutdown_Pin, OUTPUT);

  digitalWrite(Shutdown_Pin, LOW);    // Shutdown the Pots - Shows Output as open circuit

#if debug
  Serial.begin(9600); // Start the serial port if debugging
#endif

  SPI.begin();    // initialize SPI

#if debug
  Serial.println("Ready");
#endif

  //Preload the Pots with all 254's
  Row = 12;
  PotWrite();;
}

void loop()
{
  // Check the keypad
  char key = keypad.getKey();

  if (key)  //If there is a key pressed
  {
#if debug
    Serial.print("Key pressed: ");
    Serial.println(key);
#endif

  // Determine which key is pressed and select the pot value array row number

    switch (key)
    {
      case '1':
        Row = 0;
        break;

      case '2':
        Row = 1;
        break;

      case '3':
        Row = 2;
        break;

      case '4':
        Row = 3;
        break;

      case '5':
        Row = 4;
        break;

      case '6':
        Row = 5;
        break;

      case '7':
        Row = 6;
        break;

      case '8':
        Row = 7;
        break;

      case '9':
        Row = 8;
        break;

      case '*':
        Row = 9;
        break;

      case '0':
        Row = 10;
        break;

      case '#':
        Row = 11;
        break;

      case 'A':
        Row = -1;
        break;

      case 'B':
        Row = -1;
        break;

      case 'C':
        Row = -1;
        break;

      case 'D':
        Row = -1;
        break;

      default:
        Row = -1;
    }

#if debug
    Serial.print("Array Index: ");
    Serial.println(Row);
#endif

    if (Row != -1)
    {

      PotWrite(); // Write the array values to the pots
      digitalWrite(Shutdown_Pin, HIGH); // Enable the Pot chips for 500ms
      delay(500);

#if debug
  delay(5000);
#endif  
      
      digitalWrite(Shutdown_Pin, LOW);  // Disable the Pot chips
    }
  }
}

// The PotWrite Function
void PotWrite()
{
#if debug
  Serial.print("Row: ");
  Serial.print(Row);
  Serial.print("   ");
  Serial.print(Value[Row][0]);
  Serial.print("   ");
  Serial.print(Value[Row][1]);
  Serial.print("   ");
  Serial.print(Value[Row][2]);
  Serial.print("   ");
  Serial.println(Value[Row][3]);
#endif

  digitalWrite(Chip_A, LOW);    // Set the SS pin low to select the first pot chip
  SPI.transfer(B00010001);    //  Send the address for Pot A
  SPI.transfer(Value[Row][0]);    //  Send the value for Pot A
  digitalWrite(Chip_A, HIGH); // Deselect the pot chip
  digitalWrite(Chip_A, LOW);    // Set the SS pin low to select the first pot chip again
  SPI.transfer(B00010010);    //  Send the address for Pot B
  SPI.transfer(Value[Row][1]);    //  Send the value for Pot B
  digitalWrite(Chip_A, HIGH); // Deselect the pot chip

  digitalWrite(Chip_B, LOW);    // Set the SS pin low to select the second pot chip
  SPI.transfer(B00010001);    //  Send the address for Pot A
  SPI.transfer(Value[Row][2]);    //  Send the value for Pot A
  digitalWrite(Chip_B, HIGH); // Deselect the pot chip
  digitalWrite(Chip_B, LOW);    // Set the SS pin low to select the second pot chip again
  SPI.transfer(B00010010);    //  Send the address for Pot B
  SPI.transfer(Value[Row][3]);    //  Send the value for Pot B
  digitalWrite(Chip_B, HIGH); // Deselect the pot chip

}

